package xyz.hermez.components;

import android.app.Activity;
import android.content.DialogInterface;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.core.app.ShareCompat;
import com.google.firebase.BuildConfig;
import java.lang.reflect.Method;
import java.util.Locale;
import xyz.hermez.R;
import xyz.hermez.Utils;

/* loaded from: classes.dex */
public class WebPageNativeAPI {
    public static final String WEBVIEW_INTERFACE_NAME = "app__api";
    protected Activity activity;
    protected WebView topView;
    protected WebView view;
    protected int dialogCallbackID = 1;
    protected String consumeBackKeyMode = "no";

    public WebPageNativeAPI(Activity activity, WebView webView) {
        this.activity = activity;
        this.view = webView;
    }

    public void setTopView(WebView webView) {
        this.topView = webView;
    }

    /* JADX WARN: Multi-variable type inference failed */
    protected Method findHandlerMethod(String str, Class cls) throws NoSuchMethodException {
        return getClass().getMethod(str, cls);
    }

    @JavascriptInterface
    public void api_call(String str, String str2, String str3) {
        String str4;
        try {
            str4 = findHandlerMethod("js_" + str, str2.getClass()).invoke(this, str2).toString();
        } catch (Exception e) {
            e.printStackTrace();
            str4 = BuildConfig.FLAVOR;
        }
        sendJavascript(String.format("DeviceAPI.__callbackResult('%s', '%s');", str3, str4), this.view);
    }

    @JavascriptInterface
    public void menuview_api_call(String str, String str2, String str3) {
        String str4;
        try {
            str4 = findHandlerMethod("js_" + str, str2.getClass()).invoke(this, str2).toString();
        } catch (Exception e) {
            e.printStackTrace();
            str4 = BuildConfig.FLAVOR;
        }
        sendJavascript(String.format("DeviceAPI.__callbackResult('%s', '%s');", str3, str4), this.topView);
    }

    public void sendJavascript(String str) {
        sendJavascript(str, this.view);
    }

    public void sendJavascript(final String str, final WebView webView) {
        if (webView == null) {
            Utils.log("no view available");
        } else {
            this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.components.WebPageNativeAPI.1
                @Override // java.lang.Runnable
                public void run() {
                    webView.evaluateJavascript(str, null);
                }
            });
        }
    }

    public String js_open_url(String str) {
        Utils.openURL(this.activity, str);
        return BuildConfig.FLAVOR;
    }

    public String js_share_text(String str) {
        ShareCompat.IntentBuilder.from(this.activity).setText(str).setType("text/plain").setChooserTitle(this.activity.getString(R.string.share_content)).startChooser();
        return "OK";
    }

    public String js_toast(String str) {
        Toast.makeText(this.activity, str, 0).show();
        return BuildConfig.FLAVOR;
    }

    public String js_app_version(String str) {
        return String.format(Locale.ENGLISH, "%s.%02d", Utils.getAppVersion(this.activity), Integer.valueOf(Utils.getAppVersionCode(this.activity)));
    }

    public String js_alert(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("dialog_callback_");
        int i = this.dialogCallbackID;
        this.dialogCallbackID = i + 1;
        sb.append(i);
        final String sb2 = sb.toString();
        Utils.alert(this.activity, str, new DialogInterface.OnClickListener() { // from class: xyz.hermez.components.WebPageNativeAPI.2
            @Override // android.content.DialogInterface.OnClickListener
            public void onClick(DialogInterface dialogInterface, int i2) {
                WebPageNativeAPI.this.sendJavascript(String.format("if(DeviceAPI && '__callbackResult' in DeviceAPI) { DeviceAPI.__callbackResult('%s', '%s'); }", sb2, BuildConfig.FLAVOR));
            }
        });
        return sb2;
    }

    public String js_prompt(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("dialog_callback_");
        int i = this.dialogCallbackID;
        this.dialogCallbackID = i + 1;
        sb.append(i);
        final String sb2 = sb.toString();
        Utils.prompt(this.activity, str, new IStringCallback() { // from class: xyz.hermez.components.WebPageNativeAPI.3
            @Override // xyz.hermez.components.IStringCallback
            public void onCallback(String str2) {
                WebPageNativeAPI.this.sendJavascript(String.format("DeviceAPI.__callbackResult('%s', '%s');", sb2, str2));
            }
        });
        return sb2;
    }

    public String js_getSharedPref(String str) {
        return Utils.getPrefString(this.activity, str, BuildConfig.FLAVOR);
    }

    public String js_setSharedPref(String str) {
        if (str.indexOf(58) < 0) {
            return "FAIL FORMAT";
        }
        String[] split = str.split(":", 2);
        if (split.length < 2) {
            return "FAIL NO VAL";
        }
        Utils.savePrefString(this.activity, split[0], split[1]);
        return "OK";
    }

    public String js_showLoader(String str) {
        if (!(this.view instanceof WebPageView)) {
            return "unsupported";
        }
        ((WebPageView) this.view).setLoaderVisibility(str != null && str.toLowerCase().trim().equals("yes"));
        return "OK";
    }

    public String js_quit(String str) {
        CookieManager.getInstance().removeAllCookies(new ValueCallback<Boolean>() { // from class: xyz.hermez.components.WebPageNativeAPI.4
            @Override // android.webkit.ValueCallback
            public void onReceiveValue(Boolean bool) {
                WebPageNativeAPI.this.activity.finish();
            }
        });
        return "OK";
    }

    public String js_navigateBack(final String str) {
        if (this.view == null) {
            return BuildConfig.FLAVOR;
        }
        this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.components.WebPageNativeAPI.5
            @Override // java.lang.Runnable
            public void run() {
                String str2;
                if (WebPageNativeAPI.this.view.canGoBack()) {
                    WebPageNativeAPI.this.view.goBack();
                    str2 = "OK";
                } else {
                    str2 = "FAIL";
                }
                WebPageNativeAPI.this.sendJavascript(String.format("DeviceAPI.__callbackResult('%s', '%s');", str, str2));
            }
        });
        return "WAIT";
    }

    protected void sendBackKeyEvent() {
        sendJavascript("DeviceAPI.onBackButtonPressed();");
    }

    public String js_consumeBackKey(String str) {
        Utils.log("consume back " + str);
        if (str == null || (!str.equals("yes") && !str.equals("once"))) {
            str = "no";
        }
        this.consumeBackKeyMode = str;
        return str;
    }

    public boolean consumeBackKey() {
        boolean z = true;
        if (this.consumeBackKeyMode.equals("once")) {
            this.consumeBackKeyMode = "no";
        } else if (!this.consumeBackKeyMode.equals("yes")) {
            z = false;
        }
        if (z) {
            sendBackKeyEvent();
        }
        return z;
    }

    public void UIThreadResultCallback(final String str, final String str2) {
        if (this.view != null) {
            this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.components.WebPageNativeAPI.6
                @Override // java.lang.Runnable
                public void run() {
                    String format = String.format("DeviceAPI.__callbackResult('%s', '%s');", str2, str);
                    WebPageNativeAPI webPageNativeAPI = WebPageNativeAPI.this;
                    webPageNativeAPI.sendJavascript(format, webPageNativeAPI.topView);
                }
            });
        }
    }
}
