package xyz.hermez;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ParseException;
import android.net.Uri;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.FrameLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import xyz.hermez.components.IStringCallback;

/* loaded from: classes.dex */
public class Utils {
    public static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(MainActivity.class.getName(), 0);
    }

    public static String getPrefString(Context context, String str) {
        return getPrefString(context, str, com.google.firebase.BuildConfig.FLAVOR);
    }

    public static String getPrefString(Context context, String str, String str2) {
        return getSharedPreferences(context).getString(str, str2);
    }

    public static long getPrefInt(Context context, String str) {
        return getSharedPreferences(context).getLong(str, 0L);
    }

    public static boolean savePrefLong(Context context, String str, long j) {
        SharedPreferences.Editor edit = getSharedPreferences(context).edit();
        edit.putLong(str, j);
        return edit.commit();
    }

    public static boolean savePrefString(Context context, String str, String str2) {
        SharedPreferences.Editor edit = getSharedPreferences(context).edit();
        edit.putString(str, str2);
        return edit.commit();
    }

    public static AlertDialog.Builder createDialogBuilder(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(context.getString(R.string.app_name)).setCancelable(false);
        builder.setOnKeyListener(new DialogInterface.OnKeyListener() { // from class: xyz.hermez.Utils.1
            @Override // android.content.DialogInterface.OnKeyListener
            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                if (i != 4) {
                    return false;
                }
                dialogInterface.dismiss();
                return true;
            }
        });
        return builder;
    }

    public static void alert(Context context, String str) {
        alert(context, str, null);
    }

    public static void alert(Context context, String str, final DialogInterface.OnClickListener onClickListener) {
        createDialogBuilder(context).setMessage(str).setPositiveButton(R.string.okay, new DialogInterface.OnClickListener() { // from class: xyz.hermez.Utils.2
            @Override // android.content.DialogInterface.OnClickListener
            public void onClick(DialogInterface dialogInterface, int i) {
                DialogInterface.OnClickListener onClickListener2 = onClickListener;
                if (onClickListener2 != null) {
                    onClickListener2.onClick(dialogInterface, i);
                }
                dialogInterface.dismiss();
            }
        }).show();
    }

    public static void confirm(Context context, String str, DialogInterface.OnClickListener onClickListener) {
        createDialogBuilder(context).setMessage(str).setPositiveButton(R.string.okay, onClickListener).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() { // from class: xyz.hermez.Utils.3
            @Override // android.content.DialogInterface.OnClickListener
            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).show();
    }

    public static void prompt(Context context, String str, final IStringCallback iStringCallback) {
        final AppCompatEditText appCompatEditText = new AppCompatEditText(context);
        FrameLayout frameLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        layoutParams.setMargins(20, 0, 20, 0);
        appCompatEditText.setLayoutParams(layoutParams);
        frameLayout.addView(appCompatEditText);
        AlertDialog.Builder negativeButton = createDialogBuilder(context).setMessage(str).setPositiveButton(R.string.okay, new DialogInterface.OnClickListener() { // from class: xyz.hermez.Utils.5
            @Override // android.content.DialogInterface.OnClickListener
            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
                if (IStringCallback.this != null) {
                    IStringCallback.this.onCallback(appCompatEditText.getText().toString());
                }
            }
        }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() { // from class: xyz.hermez.Utils.4
            @Override // android.content.DialogInterface.OnClickListener
            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        });
        negativeButton.setView(frameLayout);
        negativeButton.show();
    }

    public static String getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException unused) {
            return com.google.firebase.BuildConfig.FLAVOR;
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException unused) {
            return 0;
        }
    }

    public static String endpointURL(String str) {
        return String.format("%s%s", BuildConfig.SERVER_URL, str);
    }

    public static boolean urlIsOnDomain(String str) {
        return str != null && str.toLowerCase().startsWith(BuildConfig.SERVER_URL);
    }

    public static String getDomainName(String str) throws URISyntaxException {
        String host = new URI(str.trim().toLowerCase()).getHost();
        return host.startsWith("www.") ? host.substring(4) : host;
    }

    public static String HttpUserAgent(Context context, String str) {
        return String.format("%s Hermez-WV/%s", str, Integer.valueOf(getAppVersionCode(context)));
    }

    public static String HttpUserAgent(Context context) {
        return HttpUserAgent(context, com.google.firebase.BuildConfig.FLAVOR);
    }

    public static Bundle mapToBundle(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (String str : map.keySet()) {
            bundle.putString(str, map.get(str));
        }
        return bundle;
    }

    public static String mapToUrlQuery(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (String str : map.keySet()) {
            try {
                sb.append(str);
                sb.append("=");
                sb.append(URLEncoder.encode(map.get(str), "UTF8"));
                sb.append("&");
            } catch (Exception unused) {
            }
        }
        return sb.toString();
    }

    public static String openURL(Activity activity, String str) {
        activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse(str)));
        return com.google.firebase.BuildConfig.FLAVOR;
    }

    public static JSONObject getOnGoingShipment(Context context) {
        try {
            return new JSONObject(getPrefString(context, "ongoing_shipment"));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String timestampWithTz() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZZ", Locale.getDefault()).format(new Date());
    }

    public static String formatDate(String str, String str2) throws ParseException {
        try {
            return formatDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(str), str2);
        } catch (java.text.ParseException e) {
            e.printStackTrace();
            return "INVALID DATE";
        }
    }

    public static String formatDate(String str) throws ParseException {
        return formatDate(str, "dd MMM yyyy HH:mm");
    }

    public static String formatDate(Date date) {
        return formatDate(date, "dd MMM yyyy HH:mm");
    }

    public static String formatDate(Date date, String str) {
        return DateFormat.format(str, date).toString();
    }

    public static void deleteCache(Context context) {
        try {
            deleteDir(context.getCacheDir());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteDir(File file) {
        if (file != null && file.isDirectory()) {
            for (String str : file.list()) {
                if (!deleteDir(new File(file, str))) {
                    return false;
                }
            }
            return file.delete();
        }
        if (file == null || !file.isFile()) {
            return false;
        }
        return file.delete();
    }

    public static void stdout(Object obj) {
        Log.i("app.utils", obj.toString());
    }

    public static void stderr(Object obj) {
        Log.e("lex.utils", obj.toString());
    }

    public static String exceptionStackTrace(Exception exc) {
        StringWriter stringWriter = new StringWriter();
        exc.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void log(String str) {
        stdout(str);
    }

    public static void logException(Exception exc) {
        log(exceptionStackTrace(exc));
    }
}
