package xyz.hermez;

import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import com.google.android.gms.common.internal.ImagesContract;
import com.onesignal.OneSignalDbContract;
import xyz.hermez.components.WebPageNativeAPI;
import xyz.hermez.components.WebPageView;

/* loaded from: classes.dex */
public class ResultActivity extends AppCompatActivity {
    protected String title;
    protected String url;
    WebPageView webPageView;

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.fragment.app.FragmentActivity, androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, android.app.Activity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        AppCompatDelegate.setDefaultNightMode(1);
        if (BuildConfig.AllowAutoRotate.booleanValue()) {
            setRequestedOrientation(2);
        }
        Intent intent = getIntent();
        this.url = intent.getStringExtra(ImagesContract.URL);
        String stringExtra = intent.getStringExtra(OneSignalDbContract.NotificationTable.COLUMN_NAME_TITLE);
        this.title = stringExtra;
        if (stringExtra == null || stringExtra.isEmpty()) {
            this.title = "Pemberitahuan";
        }
        setTitle(this.title);
        initLayout();
    }

    private void initLayout() {
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        setContentView(R.layout.activity_result);
        WebPageView webPageView = (WebPageView) findViewById(R.id.browser);
        this.webPageView = webPageView;
        webPageView.addJavascriptInterface((WebPageNativeAPI) new BrowserNativeAPI(this, this.webPageView), "hermez");
        String str = this.url;
        if (str == null || str.isEmpty()) {
            this.webPageView.loadUrl(BuildConfig.RESULT_SERVER_URL);
        } else {
            this.webPageView.loadUrl(this.url);
        }
    }

    private void backHome() {
        finish();
    }

    @Override // android.app.Activity
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            backHome();
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void onBackPressed() {
        WebPageView webPageView = this.webPageView;
        if (webPageView != null && webPageView.canGoBack()) {
            this.webPageView.goBack();
        } else {
            super.onBackPressed();
        }
    }
}
