package xyz.hermez;

import android.content.Context;
import android.util.Log;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationReceivedEvent;
import com.onesignal.OneSignal;

/* loaded from: classes.dex */
public class NotificationServiceExtension implements OneSignal.OSRemoteNotificationReceivedHandler {
    @Override // com.onesignal.OneSignal.OSRemoteNotificationReceivedHandler
    public void remoteNotificationReceived(Context context, OSNotificationReceivedEvent oSNotificationReceivedEvent) {
        OSNotification notification = oSNotificationReceivedEvent.getNotification();
        String title = notification.getTitle();
        String optString = notification.getAdditionalData().optString("mode", com.google.firebase.BuildConfig.FLAVOR);
        Log.d("NOTIFEXTENDER", title + " - " + optString);
        String lowerCase = optString.trim().toLowerCase();
        if (lowerCase.equals("result")) {
            Utils.savePrefLong(context.getApplicationContext(), MainActivity.PREF_NOTIF_RESULT_COUNT, Utils.getPrefInt(context.getApplicationContext(), MainActivity.PREF_NOTIF_RESULT_COUNT) + 1);
        } else if (lowerCase.equals("news")) {
            Utils.savePrefLong(context.getApplicationContext(), MainActivity.PREF_NOTIF_NEWS_COUNT, Utils.getPrefInt(context.getApplicationContext(), MainActivity.PREF_NOTIF_NEWS_COUNT) + 1);
        }
        oSNotificationReceivedEvent.complete(notification);
        Log.d("NOTIFEXTENDER", "notif completed: " + title);
    }
}
