package xyz.hermez;

import android.app.ActivityManager;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.ImagesContract;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationOpenedResult;
import com.onesignal.OSNotificationReceivedEvent;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbContract;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.json.JSONObject;
import xyz.hermez.components.WebLoaderProgressHandler;
import xyz.hermez.components.WebPageNativeAPI;
import xyz.hermez.components.WebPageView;

/* loaded from: classes.dex */
public class MainActivity extends AppCompatActivity implements OneSignal.OSNotificationOpenedHandler, WebLoaderProgressHandler {
    public static final String PREF_NOTIF_NEWS_COUNT = "notif_news_count";
    public static final String PREF_NOTIF_RESULT_COUNT = "notif_result_count";
    public static final String TAG = "HERMEZ";
    ConstraintLayout appLoaderView;
    ProgressBar loaderProgress;
    public String mCameraPhotoPath;
    public ValueCallback<Uri[]> mFilePathCallback;
    TextView progressText;
    WebPageView topmenuPage;
    WebPageView webPageView;
    boolean showLoadProgress = true;
    public boolean mainURLCalled = false;

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.fragment.app.FragmentActivity, androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, android.app.Activity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        AppCompatDelegate.setDefaultNightMode(1);
        OneSignal.sendTag("HERMEZ_ID", BuildConfig.APPLICATION_ID);
        OneSignal.sendTag("HERMEZ_BUILD", "16");
        OneSignal.setNotificationOpenedHandler(this);
        OneSignal.setNotificationWillShowInForegroundHandler(new OneSignal.OSNotificationWillShowInForegroundHandler() { // from class: xyz.hermez.MainActivity$$ExternalSyntheticLambda0
            @Override // com.onesignal.OneSignal.OSNotificationWillShowInForegroundHandler
            public final void notificationWillShowInForeground(OSNotificationReceivedEvent oSNotificationReceivedEvent) {
                MainActivity.this.lambda$onCreate$0$MainActivity(oSNotificationReceivedEvent);
            }
        });
        if (BuildConfig.HideStatusBar.booleanValue()) {
            getWindow().setFlags(1024, 1024);
        }
        setContentView(R.layout.activity_main_bottommenu);
        initLayout();
        handleLoaderPercentage();
        checkPermission(new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
    }

    public /* synthetic */ void lambda$onCreate$0$MainActivity(OSNotificationReceivedEvent oSNotificationReceivedEvent) {
        OSNotification notification = oSNotificationReceivedEvent.getNotification();
        String title = notification.getTitle();
        String optString = notification.getAdditionalData().optString("mode", com.google.firebase.BuildConfig.FLAVOR);
        Log.d("NOTIFX", title + " - " + optString);
        String lowerCase = optString.trim().toLowerCase();
        if (lowerCase.equals("result") || lowerCase.equals("news")) {
            runOnUiThread(new Runnable() { // from class: xyz.hermez.MainActivity.1
                @Override // java.lang.Runnable
                public void run() {
                    try {
                        MainActivity.this.topmenuPage.reload();
                    } catch (Exception unused) {
                    }
                }
            });
        }
        oSNotificationReceivedEvent.complete(notification);
        Log.d("NOTIFX", "notif completed: " + title);
    }

    protected void handleLoaderPercentage() {
        this.appLoaderView = (ConstraintLayout) findViewById(R.id.app_loader_mask);
        this.loaderProgress = (ProgressBar) findViewById(R.id.mask_progressbar);
        this.progressText = (TextView) findViewById(R.id.progress_text);
        this.webPageView.setProgressHandler(this);
    }

    public void hideProgressView() {
        this.appLoaderView.animate().alpha(0.0f).setDuration(800L).withEndAction(new Runnable() { // from class: xyz.hermez.MainActivity.2
            @Override // java.lang.Runnable
            public void run() {
                if (BuildConfig.AllowAutoRotate.booleanValue()) {
                    MainActivity.this.setRequestedOrientation(2);
                }
                MainActivity.this.appLoaderView.setVisibility(4);
                MainActivity.this.progressText.setText("0%");
                MainActivity.this.loaderProgress.setProgress(0);
            }
        }).start();
    }

    protected void adjustTopmenuHeight() {
        if (BuildConfig.AdjustTopBarHeight.booleanValue()) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            int i = displayMetrics.heightPixels;
            if (displayMetrics.widthPixels / displayMetrics.density > 400.0d) {
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams) this.topmenuPage.getLayoutParams();
                layoutParams.height = (int) (displayMetrics.density * 50.0f);
                this.topmenuPage.setLayoutParams(layoutParams);
            }
        }
    }

    public void forceTopmenuHeight(final int i) {
        runOnUiThread(new Runnable() { // from class: xyz.hermez.MainActivity.3
            @Override // java.lang.Runnable
            public void run() {
                if (BuildConfig.AdjustTopBarHeight.booleanValue()) {
                    DisplayMetrics displayMetrics = new DisplayMetrics();
                    MainActivity.this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
                    ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams) MainActivity.this.topmenuPage.getLayoutParams();
                    layoutParams.height = (int) (i * displayMetrics.density);
                    MainActivity.this.topmenuPage.setLayoutParams(layoutParams);
                }
            }
        });
    }

    public void showProgressView() {
        if (this.appLoaderView.getVisibility() == 0) {
            return;
        }
        this.appLoaderView.setAlpha(0.0f);
        this.appLoaderView.setVisibility(0);
        this.appLoaderView.animate().alpha(1.0f).setDuration(500L).withEndAction(new Runnable() { // from class: xyz.hermez.MainActivity.4
            @Override // java.lang.Runnable
            public void run() {
                MainActivity.this.showLoadProgress = true;
            }
        }).start();
    }

    @Override // xyz.hermez.components.WebLoaderProgressHandler
    public void onWebviewProgressChanged(WebView webView, int i) {
        if (this.showLoadProgress) {
            showProgressView();
            int min = Math.min(i, 100);
            this.progressText.setText(String.format("%02d%%", Integer.valueOf(min)));
            this.loaderProgress.setProgress(min);
            if (min >= 100) {
                this.showLoadProgress = false;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable() { // from class: xyz.hermez.MainActivity.5
                    @Override // java.lang.Runnable
                    public void run() {
                        MainActivity.this.hideProgressView();
                    }
                }, 1000L);
            }
        }
    }

    private void initLayout() {
        this.topmenuPage = (WebPageView) findViewById(R.id.top_browser);
        WebPageView webPageView = (WebPageView) findViewById(R.id.browser);
        this.webPageView = webPageView;
        webPageView.setActivity(this);
        adjustTopmenuHeight();
        BrowserNativeAPI browserNativeAPI = new BrowserNativeAPI(this, this.webPageView);
        browserNativeAPI.setTopView(this.topmenuPage);
        this.topmenuPage.addJavascriptInterface((WebPageNativeAPI) browserNativeAPI, "hermez");
        this.topmenuPage.loadUrl(BuildConfig.MENU_SERVER_URL);
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() { // from class: xyz.hermez.MainActivity.6
            @Override // java.lang.Runnable
            public void run() {
                MainActivity.this.loadMainURL(BuildConfig.SERVER_URL);
            }
        }, 8000L);
    }

    public void loadMainURL(String str) {
        if (this.mainURLCalled) {
            return;
        }
        this.mainURLCalled = true;
        this.webPageView.loadUrl(str);
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void onBackPressed() {
        WebPageView webPageView = this.webPageView;
        if (webPageView != null && webPageView.canGoBack()) {
            this.webPageView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void showResultPage(String str, String str2) {
        Intent intent = new Intent(this, (Class<?>) ResultActivity.class);
        intent.putExtra(ImagesContract.URL, str);
        intent.putExtra(OneSignalDbContract.NotificationTable.COLUMN_NAME_TITLE, str2);
        startActivity(intent);
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onResume() {
        this.topmenuPage.reload();
        super.onResume();
    }

    @Override // com.onesignal.OneSignal.OSNotificationOpenedHandler
    public void notificationOpened(OSNotificationOpenedResult oSNotificationOpenedResult) {
        JSONObject additionalData = oSNotificationOpenedResult.getNotification().getAdditionalData();
        if (additionalData == null) {
            return;
        }
        Log.d(TAG, "Notification data: " + additionalData.toString());
        String optString = additionalData.optString("mode", com.google.firebase.BuildConfig.FLAVOR);
        optString.hashCode();
        if (optString.equals("result") || optString.equals("news")) {
            showResultPage(additionalData.optString(ImagesContract.URL, com.google.firebase.BuildConfig.FLAVOR), additionalData.optString(OneSignalDbContract.NotificationTable.COLUMN_NAME_TITLE, com.google.firebase.BuildConfig.FLAVOR));
        }
    }

    public void addNotifResultCount() {
        Utils.savePrefLong(this, PREF_NOTIF_RESULT_COUNT, getNotifResultCount() + 1);
    }

    public long getNotifResultCount() {
        return Utils.getPrefInt(this, PREF_NOTIF_RESULT_COUNT);
    }

    public void addNotifNewsResultCount() {
        Utils.savePrefLong(this, PREF_NOTIF_NEWS_COUNT, getNotifNewsCount() + 1);
    }

    public long getNotifNewsCount() {
        return Utils.getPrefInt(this, PREF_NOTIF_NEWS_COUNT);
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r7v1 */
    /* JADX WARN: Type inference failed for: r7v12 */
    /* JADX WARN: Type inference failed for: r7v17 */
    /* JADX WARN: Type inference failed for: r7v2, types: [java.lang.Object] */
    /* JADX WARN: Type inference failed for: r7v22, types: [android.net.Uri[]] */
    /* JADX WARN: Type inference failed for: r7v23 */
    /* JADX WARN: Type inference failed for: r7v24 */
    /* JADX WARN: Type inference failed for: r7v3 */
    /* JADX WARN: Type inference failed for: r7v4 */
    /* JADX WARN: Type inference failed for: r7v5, types: [android.os.Bundle] */
    /* JADX WARN: Type inference failed for: r7v6 */
    @Override // androidx.fragment.app.FragmentActivity, androidx.activity.ComponentActivity, android.app.Activity
    public void onActivityResult(int i, int i2, Intent intent) {
        ?? r7;
        Uri[] uriArr;
        Log.e("XXX", "RES " + i + "  " + i2 + com.google.firebase.BuildConfig.FLAVOR);
        if (i != 1 || this.mFilePathCallback == null) {
            super.onActivityResult(i, i2, intent);
            return;
        }
        if (i2 == -1) {
            if (intent == null) {
                Log.e("XXX", "x1");
                if (this.mCameraPhotoPath != null) {
                    Log.e("XXX", "MC: " + this.mCameraPhotoPath);
                    r7 = new Uri[]{Uri.parse(this.mCameraPhotoPath)};
                }
            } else {
                try {
                    r7 = intent.getExtras();
                    if (r7 != 0) {
                        try {
                            Bitmap bitmap = (Bitmap) intent.getExtras().get("data");
                            File createImageFile = WebPageView.createImageFile();
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(createImageFile.getAbsolutePath());
                                try {
                                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, fileOutputStream);
                                    uriArr = new Uri[]{Uri.fromFile(createImageFile)};
                                    try {
                                        fileOutputStream.close();
                                        r7 = uriArr;
                                    } catch (IOException e) {
                                        e = e;
                                        Utils.alert(this, "Error saving image: " + e.getMessage());
                                        r7 = uriArr;
                                        this.mFilePathCallback.onReceiveValue(r7);
                                        this.mFilePathCallback = null;
                                    }
                                } finally {
                                }
                            } catch (IOException e2) {
                                e = e2;
                                uriArr = null;
                            }
                        } catch (Exception e3) {
                            e = e3;
                            Utils.alert(this, "Error Reading File: " + e.getMessage());
                            this.mFilePathCallback.onReceiveValue(r7);
                            this.mFilePathCallback = null;
                        }
                    } else {
                        String dataString = intent.getDataString();
                        if (dataString != null) {
                            Log.e("XXX", "Results: " + dataString);
                            r7 = new Uri[]{Uri.parse(dataString)};
                        }
                    }
                } catch (Exception e4) {
                    e = e4;
                    r7 = 0;
                }
            }
            this.mFilePathCallback.onReceiveValue(r7);
            this.mFilePathCallback = null;
        }
        r7 = 0;
        this.mFilePathCallback.onReceiveValue(r7);
        this.mFilePathCallback = null;
    }

    private void clearCache() {
        try {
            if (19 <= Build.VERSION.SDK_INT) {
                ((ActivityManager) getApplicationContext().getSystemService("activity")).clearApplicationUserData();
            }
        } catch (Exception e) {
            Log.e(TAG, "Error clear cache");
            e.printStackTrace();
        }
    }

    public void checkPermission(String[] strArr, int i) {
        for (String str : strArr) {
            if (ContextCompat.checkSelfPermission(this, str) == -1) {
                ActivityCompat.requestPermissions(this, new String[]{str}, i);
            }
        }
    }
}
