package xyz.hermez;

import android.app.Activity;
import android.util.Log;
import android.webkit.WebView;
import com.google.android.gms.common.internal.ImagesContract;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbContract;
import org.json.JSONException;
import org.json.JSONObject;
import xyz.hermez.components.WebPageNativeAPI;
import xyz.hermez.components.WebPageView;

/* loaded from: classes.dex */
public class BrowserNativeAPI extends WebPageNativeAPI {
    public boolean isFromMainActivity;

    public BrowserNativeAPI(Activity activity, WebView webView) {
        super(activity, webView);
        this.view = webView;
        this.isFromMainActivity = activity instanceof MainActivity;
    }

    public String js_loadUrl(String str) {
        Log.d("BNA", "loadurl param: " + str);
        try {
            JSONObject jSONObject = new JSONObject(str);
            final String optString = jSONObject.optString(OneSignalDbContract.NotificationTable.COLUMN_NAME_TITLE);
            String optString2 = jSONObject.optString(ImagesContract.URL);
            final boolean optBoolean = jSONObject.optBoolean("new_window", false);
            boolean equals = optString2.equals("__home__");
            final boolean z = equals || jSONObject.optBoolean("clear_history", true);
            if (equals) {
                optString2 = BuildConfig.SERVER_URL;
            }
            final String str2 = optString2;
            this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.BrowserNativeAPI.1
                @Override // java.lang.Runnable
                public void run() {
                    if (!optBoolean || !BrowserNativeAPI.this.isFromMainActivity) {
                        BrowserNativeAPI.this.view.stopLoading();
                        if (z && (BrowserNativeAPI.this.view instanceof WebPageView)) {
                            Log.d("BNA", "clear history");
                            BrowserNativeAPI.this.view.clearHistory();
                            ((WebPageView) BrowserNativeAPI.this.view).setClearHistoryOnFinished(true);
                        }
                        BrowserNativeAPI.this.view.loadUrl(str2);
                        return;
                    }
                    ((MainActivity) BrowserNativeAPI.this.activity).showResultPage(str2, optString);
                }
            });
            return "OK";
        } catch (JSONException unused) {
            return "INVALID JSON PARAM";
        }
    }

    public String js_loadMainURL(final String str) {
        if (!this.isFromMainActivity) {
            return "NOT_SUPPORTED_ACT";
        }
        this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.BrowserNativeAPI.2
            @Override // java.lang.Runnable
            public void run() {
                ((MainActivity) BrowserNativeAPI.this.activity).loadMainURL(str);
            }
        });
        return "OK";
    }

    public String js_setActivityTitle(final String str) {
        if (this.activity == null) {
            return "FAIL_NOT_SUPPORTED";
        }
        this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.BrowserNativeAPI.3
            @Override // java.lang.Runnable
            public void run() {
                try {
                    BrowserNativeAPI.this.activity.setTitle(str);
                } catch (Exception e) {
                    Log.e("BNA", "ERROR SET TITLE", e);
                }
            }
        });
        return "OK";
    }

    public String js_openResultWindow(String str) {
        if (!(this.activity instanceof MainActivity)) {
            return "FAIL_UNSUPPORTED_ACTIVITY";
        }
        try {
            JSONObject jSONObject = new JSONObject(str);
            final String optString = jSONObject.optString(OneSignalDbContract.NotificationTable.COLUMN_NAME_TITLE);
            final String optString2 = jSONObject.optString(ImagesContract.URL);
            if (optString2 != null && optString2.equals("__result__")) {
                optString2 = BuildConfig.RESULT_SERVER_URL;
            }
            this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.BrowserNativeAPI.4
                @Override // java.lang.Runnable
                public void run() {
                    ((MainActivity) BrowserNativeAPI.this.activity).showResultPage(optString2, optString);
                }
            });
            return "OK";
        } catch (JSONException unused) {
            return "INVALID JSON PARAM";
        }
    }

    public String js_notifResultCount(String str) {
        return Utils.getPrefInt(this.activity, MainActivity.PREF_NOTIF_RESULT_COUNT) + com.google.firebase.BuildConfig.FLAVOR;
    }

    public String js_notifNewsCount(String str) {
        return Utils.getPrefInt(this.activity, MainActivity.PREF_NOTIF_NEWS_COUNT) + com.google.firebase.BuildConfig.FLAVOR;
    }

    public String js_notifCount(String str) {
        return (Utils.getPrefInt(this.activity, MainActivity.PREF_NOTIF_RESULT_COUNT) + Utils.getPrefInt(this.activity, MainActivity.PREF_NOTIF_NEWS_COUNT)) + com.google.firebase.BuildConfig.FLAVOR;
    }

    public String js_clearResultCount(String str) {
        try {
            if (str.equals("clear_notif")) {
                OneSignal.clearOneSignalNotifications();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Utils.savePrefLong(this.activity, MainActivity.PREF_NOTIF_RESULT_COUNT, 0L);
        return "OK";
    }

    public String js_clearNewsCount(String str) {
        try {
            if (str.equals("clear_notif")) {
                OneSignal.clearOneSignalNotifications();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Utils.savePrefLong(this.activity, MainActivity.PREF_NOTIF_NEWS_COUNT, 0L);
        return "OK";
    }

    public String js_topMenuHeight(String str) {
        if (!this.isFromMainActivity) {
            return "ERR_NOT_SUPPORTED";
        }
        try {
            ((MainActivity) this.activity).forceTopmenuHeight(Integer.parseInt(str));
            return "OK";
        } catch (Exception unused) {
            return "ERR_INVALID_PARAM";
        }
    }

    public String js_currentURL(final String str) {
        if (this.view == null) {
            return "NO_VIEW";
        }
        this.activity.runOnUiThread(new Runnable() { // from class: xyz.hermez.BrowserNativeAPI.5
            @Override // java.lang.Runnable
            public void run() {
                String format = String.format("DeviceAPI.__callbackResult('%s', '%s');", str, BrowserNativeAPI.this.view.getUrl());
                BrowserNativeAPI browserNativeAPI = BrowserNativeAPI.this;
                browserNativeAPI.sendJavascript(format, browserNativeAPI.topView);
            }
        });
        return "THREAD_PENDING";
    }
}
