package com.onesignal.outcomes.data;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.core.app.NotificationCompat;
import com.google.firebase.BuildConfig;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalDb;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import com.onesignal.outcomes.OSOutcomeConstants;
import com.onesignal.outcomes.domain.OSCachedUniqueOutcome;
import com.onesignal.outcomes.domain.OSOutcomeEventParams;
import com.onesignal.outcomes.domain.OSOutcomeSource;
import com.onesignal.outcomes.domain.OSOutcomeSourceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.json.JSONArray;
import org.json.JSONException;

/* compiled from: OSOutcomeEventsCache.kt */
@Metadata(bv = {1, 0, 3}, d1 = {"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007¢\u0006\u0002\u0010\bJ(\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0007J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0007J4\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010&H\u0002J$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0$2\u0006\u0010/\u001a\u00020\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0$H\u0007J*\u00101\u001a\u0004\u0018\u00010&2\u0006\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u000eH\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007J\u0018\u00106\u001a\u00020\u00122\u0010\u00107\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rJ\u0010\u00108\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004¢\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F¢\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004¢\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004¢\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r8F¢\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010¨\u00069"}, d2 = {"Lcom/onesignal/outcomes/data/OSOutcomeEventsCache;", BuildConfig.FLAVOR, "logger", "Lcom/onesignal/OSLogger;", "dbHelper", "Lcom/onesignal/OneSignalDb;", "preferences", "Lcom/onesignal/OSSharedPreferences;", "(Lcom/onesignal/OSLogger;Lcom/onesignal/OneSignalDb;Lcom/onesignal/OSSharedPreferences;)V", "isOutcomesV2ServiceEnabled", BuildConfig.FLAVOR, "()Z", "unattributedUniqueOutcomeEventsSentByChannel", BuildConfig.FLAVOR, BuildConfig.FLAVOR, "getUnattributedUniqueOutcomeEventsSentByChannel", "()Ljava/util/Set;", "addIdToListFromChannel", BuildConfig.FLAVOR, "cachedUniqueOutcomes", BuildConfig.FLAVOR, "Lcom/onesignal/outcomes/domain/OSCachedUniqueOutcome;", "channelIds", "Lorg/json/JSONArray;", "channel", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "addIdsToListFromSource", "sourceBody", "Lcom/onesignal/outcomes/domain/OSOutcomeSourceBody;", "cleanCachedUniqueOutcomeEventNotifications", "notificationTableName", "notificationIdColumnName", "deleteOldOutcomeEvent", NotificationCompat.CATEGORY_EVENT, "Lcom/onesignal/outcomes/domain/OSOutcomeEventParams;", "getAllEventsToSend", BuildConfig.FLAVOR, "getIAMInfluenceSource", "Lcom/onesignal/outcomes/domain/OSOutcomeSource;", "iamInfluenceType", "Lcom/onesignal/influence/domain/OSInfluenceType;", "directSourceBody", "indirectSourceBody", "iamIds", "source", "getNotCachedUniqueInfluencesForOutcome", "Lcom/onesignal/influence/domain/OSInfluence;", "name", "influences", "getNotificationInfluenceSource", "notificationInfluenceType", "notificationIds", "saveOutcomeEvent", "eventParams", "saveUnattributedUniqueOutcomeEventsSentByChannel", "unattributedUniqueOutcomeEvents", "saveUniqueOutcomeEventParams", "onesignal_release"}, k = 1, mv = {1, 4, 2})
/* loaded from: classes.dex */
public final class OSOutcomeEventsCache {
    private final OneSignalDb dbHelper;
    private final OSLogger logger;
    private final OSSharedPreferences preferences;

    @Metadata(bv = {1, 0, 3}, k = 3, mv = {1, 4, 2})
    /* loaded from: classes.dex */
    public final /* synthetic */ class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] iArr = new int[OSInfluenceType.values().length];
            $EnumSwitchMapping$0 = iArr;
            iArr[OSInfluenceType.DIRECT.ordinal()] = 1;
            iArr[OSInfluenceType.INDIRECT.ordinal()] = 2;
            int[] iArr2 = new int[OSInfluenceType.values().length];
            $EnumSwitchMapping$1 = iArr2;
            iArr2[OSInfluenceType.DIRECT.ordinal()] = 1;
            iArr2[OSInfluenceType.INDIRECT.ordinal()] = 2;
        }
    }

    public OSOutcomeEventsCache(OSLogger logger, OneSignalDb dbHelper, OSSharedPreferences preferences) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(dbHelper, "dbHelper");
        Intrinsics.checkNotNullParameter(preferences, "preferences");
        this.logger = logger;
        this.dbHelper = dbHelper;
        this.preferences = preferences;
    }

    public final boolean isOutcomesV2ServiceEnabled() {
        OSSharedPreferences oSSharedPreferences = this.preferences;
        return oSSharedPreferences.getBool(oSSharedPreferences.getPreferencesName(), this.preferences.getOutcomesV2KeyName(), false);
    }

    public final Set<String> getUnattributedUniqueOutcomeEventsSentByChannel() {
        OSSharedPreferences oSSharedPreferences = this.preferences;
        return oSSharedPreferences.getStringSet(oSSharedPreferences.getPreferencesName(), OSOutcomeConstants.PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT, null);
    }

    public final void saveUnattributedUniqueOutcomeEventsSentByChannel(Set<String> unattributedUniqueOutcomeEvents) {
        OSSharedPreferences oSSharedPreferences = this.preferences;
        String preferencesName = oSSharedPreferences.getPreferencesName();
        Intrinsics.checkNotNull(unattributedUniqueOutcomeEvents);
        oSSharedPreferences.saveStringSet(preferencesName, OSOutcomeConstants.PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT, unattributedUniqueOutcomeEvents);
    }

    public final synchronized void deleteOldOutcomeEvent(OSOutcomeEventParams event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.dbHelper.delete("outcome", "timestamp = ?", new String[]{String.valueOf(event.getTimestamp())});
    }

    public final synchronized void saveOutcomeEvent(OSOutcomeEventParams eventParams) {
        OSOutcomeSourceBody indirectBody;
        OSOutcomeSourceBody directBody;
        Intrinsics.checkNotNullParameter(eventParams, "eventParams");
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        OSInfluenceType oSInfluenceType = OSInfluenceType.UNATTRIBUTED;
        OSInfluenceType oSInfluenceType2 = OSInfluenceType.UNATTRIBUTED;
        OSOutcomeSource outcomeSource = eventParams.getOutcomeSource();
        if (outcomeSource != null && (directBody = outcomeSource.getDirectBody()) != null) {
            JSONArray notificationIds = directBody.getNotificationIds();
            if (notificationIds != null && notificationIds.length() > 0) {
                oSInfluenceType = OSInfluenceType.DIRECT;
                jSONArray = notificationIds;
            }
            JSONArray inAppMessagesIds = directBody.getInAppMessagesIds();
            if (inAppMessagesIds != null && inAppMessagesIds.length() > 0) {
                oSInfluenceType2 = OSInfluenceType.DIRECT;
                jSONArray2 = inAppMessagesIds;
            }
        }
        OSOutcomeSource outcomeSource2 = eventParams.getOutcomeSource();
        if (outcomeSource2 != null && (indirectBody = outcomeSource2.getIndirectBody()) != null) {
            JSONArray notificationIds2 = indirectBody.getNotificationIds();
            if (notificationIds2 != null && notificationIds2.length() > 0) {
                oSInfluenceType = OSInfluenceType.INDIRECT;
                jSONArray = notificationIds2;
            }
            JSONArray inAppMessagesIds2 = indirectBody.getInAppMessagesIds();
            if (inAppMessagesIds2 != null && inAppMessagesIds2.length() > 0) {
                oSInfluenceType2 = OSInfluenceType.INDIRECT;
                jSONArray2 = inAppMessagesIds2;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("notification_ids", jSONArray.toString());
        contentValues.put(OutcomeEventsTable.COLUMN_NAME_IAM_IDS, jSONArray2.toString());
        String oSInfluenceType3 = oSInfluenceType.toString();
        if (oSInfluenceType3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String lowerCase = oSInfluenceType3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(lowerCase, "(this as java.lang.String).toLowerCase()");
        contentValues.put(OutcomeEventsTable.COLUMN_NAME_NOTIFICATION_INFLUENCE_TYPE, lowerCase);
        String oSInfluenceType4 = oSInfluenceType2.toString();
        if (oSInfluenceType4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String lowerCase2 = oSInfluenceType4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(lowerCase2, "(this as java.lang.String).toLowerCase()");
        contentValues.put(OutcomeEventsTable.COLUMN_NAME_IAM_INFLUENCE_TYPE, lowerCase2);
        contentValues.put("name", eventParams.getOutcomeId());
        contentValues.put("weight", Float.valueOf(eventParams.getWeight()));
        contentValues.put("timestamp", Long.valueOf(eventParams.getTimestamp()));
        this.dbHelper.insert("outcome", null, contentValues);
    }

    /* JADX WARN: Code restructure failed: missing block: B:10:0x0023, code lost:
    
        if (r10.moveToFirst() != false) goto L8;
     */
    /* JADX WARN: Code restructure failed: missing block: B:11:0x0025, code lost:
    
        r0 = com.onesignal.influence.domain.OSInfluenceType.INSTANCE.fromString(r10.getString(r10.getColumnIndex(com.onesignal.outcomes.data.OutcomeEventsTable.COLUMN_NAME_NOTIFICATION_INFLUENCE_TYPE)));
        r2 = com.onesignal.influence.domain.OSInfluenceType.INSTANCE.fromString(r10.getString(r10.getColumnIndex(com.onesignal.outcomes.data.OutcomeEventsTable.COLUMN_NAME_IAM_INFLUENCE_TYPE)));
        r1 = r10.getString(r10.getColumnIndex("notification_ids"));
     */
    /* JADX WARN: Code restructure failed: missing block: B:12:0x004f, code lost:
    
        if (r1 == null) goto L11;
     */
    /* JADX WARN: Code restructure failed: missing block: B:14:0x0054, code lost:
    
        r3 = r10.getString(r10.getColumnIndex(com.onesignal.outcomes.data.OutcomeEventsTable.COLUMN_NAME_IAM_IDS));
     */
    /* JADX WARN: Code restructure failed: missing block: B:15:0x005e, code lost:
    
        if (r3 == null) goto L15;
     */
    /* JADX WARN: Code restructure failed: missing block: B:17:0x0063, code lost:
    
        r5 = r3;
        r12 = r10.getString(r10.getColumnIndex("name"));
        r14 = r10.getFloat(r10.getColumnIndex("weight"));
        r15 = r10.getLong(r10.getColumnIndex("timestamp"));
     */
    /* JADX WARN: Code restructure failed: missing block: B:19:0x0082, code lost:
    
        r3 = new com.onesignal.outcomes.domain.OSOutcomeSourceBody(null, null, 3, null);
        r6 = new com.onesignal.outcomes.domain.OSOutcomeSourceBody(null, null, 3, null);
        r0 = getNotificationInfluenceSource(r0, r3, r6, r1);
        getIAMInfluenceSource(r2, r3, r6, r5, r0);
     */
    /* JADX WARN: Code restructure failed: missing block: B:20:0x0098, code lost:
    
        if (r0 == null) goto L20;
     */
    /* JADX WARN: Code restructure failed: missing block: B:21:0x009a, code lost:
    
        r13 = r0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:22:0x00a2, code lost:
    
        kotlin.jvm.internal.Intrinsics.checkNotNullExpressionValue(r12, "name");
        r8.add(new com.onesignal.outcomes.domain.OSOutcomeEventParams(r12, r13, r14, r15));
     */
    /* JADX WARN: Code restructure failed: missing block: B:27:0x009c, code lost:
    
        r0 = new com.onesignal.outcomes.domain.OSOutcomeSource(null, null);
     */
    /* JADX WARN: Code restructure failed: missing block: B:29:0x00b1, code lost:
    
        r0 = move-exception;
     */
    /* JADX WARN: Code restructure failed: missing block: B:30:0x00b2, code lost:
    
        r18.logger.error("Generating JSONArray from notifications ids outcome:JSON Failed.", r0);
     */
    /* JADX WARN: Code restructure failed: missing block: B:31:0x0061, code lost:
    
        r3 = "[]";
     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x0052, code lost:
    
        r1 = "[]";
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final synchronized List<OSOutcomeEventParams> getAllEventsToSend() {
        ArrayList arrayList;
        Cursor query;
        arrayList = new ArrayList();
        Cursor cursor = (Cursor) null;
        try {
            query = this.dbHelper.query("outcome", null, null, null, null, null, null);
        } catch (Throwable th) {
            th = th;
        }
        try {
        } catch (Throwable th2) {
            th = th2;
            cursor = query;
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            throw th;
        }
        return arrayList;
        if (!query.moveToNext()) {
            if (query != null && !query.isClosed()) {
                query.close();
            }
            return arrayList;
        }
    }

    private final OSOutcomeSource getNotificationInfluenceSource(OSInfluenceType notificationInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String notificationIds) {
        OSOutcomeSource oSOutcomeSource;
        int i = WhenMappings.$EnumSwitchMapping$0[notificationInfluenceType.ordinal()];
        if (i == 1) {
            directSourceBody.setNotificationIds(new JSONArray(notificationIds));
            oSOutcomeSource = new OSOutcomeSource(directSourceBody, null);
        } else {
            if (i != 2) {
                return null;
            }
            indirectSourceBody.setNotificationIds(new JSONArray(notificationIds));
            oSOutcomeSource = new OSOutcomeSource(null, indirectSourceBody);
        }
        return oSOutcomeSource;
    }

    private final OSOutcomeSource getIAMInfluenceSource(OSInfluenceType iamInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String iamIds, OSOutcomeSource source) {
        OSOutcomeSource directBody;
        OSOutcomeSource indirectBody;
        int i = WhenMappings.$EnumSwitchMapping$1[iamInfluenceType.ordinal()];
        if (i == 1) {
            directSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
            return (source == null || (directBody = source.setDirectBody(directSourceBody)) == null) ? new OSOutcomeSource(directSourceBody, null) : directBody;
        }
        if (i != 2) {
            return source;
        }
        indirectSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
        return (source == null || (indirectBody = source.setIndirectBody(indirectSourceBody)) == null) ? new OSOutcomeSource(null, indirectSourceBody) : indirectBody;
    }

    private final void addIdToListFromChannel(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, JSONArray channelIds, OSInfluenceChannel channel) {
        if (channelIds != null) {
            int length = channelIds.length();
            for (int i = 0; i < length; i++) {
                try {
                    String influenceId = channelIds.getString(i);
                    Intrinsics.checkNotNullExpressionValue(influenceId, "influenceId");
                    cachedUniqueOutcomes.add(new OSCachedUniqueOutcome(influenceId, channel));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final void addIdsToListFromSource(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, OSOutcomeSourceBody sourceBody) {
        if (sourceBody != null) {
            JSONArray inAppMessagesIds = sourceBody.getInAppMessagesIds();
            JSONArray notificationIds = sourceBody.getNotificationIds();
            addIdToListFromChannel(cachedUniqueOutcomes, inAppMessagesIds, OSInfluenceChannel.IAM);
            addIdToListFromChannel(cachedUniqueOutcomes, notificationIds, OSInfluenceChannel.NOTIFICATION);
        }
    }

    public final synchronized void saveUniqueOutcomeEventParams(OSOutcomeEventParams eventParams) {
        Intrinsics.checkNotNullParameter(eventParams, "eventParams");
        this.logger.debug("OneSignal saveUniqueOutcomeEventParams: " + eventParams);
        String outcomeId = eventParams.getOutcomeId();
        ArrayList arrayList = new ArrayList();
        OSOutcomeSource outcomeSource = eventParams.getOutcomeSource();
        OSOutcomeSourceBody directBody = outcomeSource != null ? outcomeSource.getDirectBody() : null;
        OSOutcomeSource outcomeSource2 = eventParams.getOutcomeSource();
        OSOutcomeSourceBody indirectBody = outcomeSource2 != null ? outcomeSource2.getIndirectBody() : null;
        addIdsToListFromSource(arrayList, directBody);
        addIdsToListFromSource(arrayList, indirectBody);
        for (OSCachedUniqueOutcome oSCachedUniqueOutcome : arrayList) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("channel_influence_id", oSCachedUniqueOutcome.getInfluenceId());
            contentValues.put("channel_type", oSCachedUniqueOutcome.getChannel().getNameValue());
            contentValues.put("name", outcomeId);
            this.dbHelper.insert("cached_unique_outcome", null, contentValues);
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:48:0x00a6, code lost:
    
        if (r4.isClosed() == false) goto L23;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final synchronized List<OSInfluence> getNotCachedUniqueInfluencesForOutcome(String name, List<OSInfluence> influences) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(influences, "influences");
        arrayList = new ArrayList();
        Cursor cursor = (Cursor) null;
        try {
            try {
                for (OSInfluence oSInfluence : influences) {
                    JSONArray jSONArray = new JSONArray();
                    JSONArray ids = oSInfluence.getIds();
                    if (ids != null) {
                        int length = ids.length();
                        for (int i = 0; i < length; i++) {
                            String string = ids.getString(i);
                            cursor = this.dbHelper.query("cached_unique_outcome", new String[0], "channel_influence_id = ? AND channel_type = ? AND name = ?", new String[]{string, oSInfluence.getInfluenceChannel().getNameValue(), name}, null, null, null, "1");
                            Intrinsics.checkNotNullExpressionValue(cursor, "cursor");
                            if (cursor.getCount() == 0) {
                                jSONArray.put(string);
                            }
                        }
                        if (jSONArray.length() > 0) {
                            OSInfluence copy = oSInfluence.copy();
                            copy.setIds(jSONArray);
                            arrayList.add(copy);
                        }
                    }
                }
            } finally {
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
            if (cursor != null) {
            }
        }
        return arrayList;
    }

    public final synchronized void cleanCachedUniqueOutcomeEventNotifications(String notificationTableName, String notificationIdColumnName) {
        Intrinsics.checkNotNullParameter(notificationTableName, "notificationTableName");
        Intrinsics.checkNotNullParameter(notificationIdColumnName, "notificationIdColumnName");
        StringBuilder sb = new StringBuilder();
        sb.append("NOT EXISTS(SELECT NULL FROM ");
        sb.append(notificationTableName);
        sb.append(" n ");
        sb.append("WHERE");
        sb.append(" n.");
        sb.append(notificationIdColumnName);
        sb.append(" = ");
        sb.append("channel_influence_id");
        sb.append(" AND ");
        sb.append("channel_type");
        sb.append(" = \"");
        String nameValue = OSInfluenceChannel.NOTIFICATION.getNameValue();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "Locale.ROOT");
        if (nameValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String lowerCase = nameValue.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(lowerCase, "(this as java.lang.String).toLowerCase(locale)");
        sb.append(lowerCase);
        sb.append("\")");
        this.dbHelper.delete("cached_unique_outcome", sb.toString(), null);
    }
}
